#!/bin/bash

# Copy this file to /usr/local/sbin 
# It controls what action is taken for each event

#version: 0.03
#last updated: Thu Dec 30 15:14:51 CET 2004

#TODO
# - add volume control via alsa

#<config>

#File where do we want to log commands executed (LOG="" to disable)
LOG=/var/log/sonypid

#In this directory I'll remember what gauge is currently adjusted
STATE=/var/local/sound/state

#Program that control brightness level (download source from: http://popies.net/sonypi/)
SPICCTRL=/usr/local/bin/spicctrl
#Program that controls audio level
AUMIX=aumix
#Program that do CD-ROM eject
EJECT=eject

#</config>


KEY="$1"
declare -i no=1

function cmd {
  #output command to log file (you can comment out
  [ -n "$LOG" ] && echo "$(date) ($KEY) #$((no++)) $*" >>/var/log/sonypid
  eval "$@"
}


case $KEY in
  fn-e) 
    cmd "$EJECT" ;;
  fn-f3) 
    if [ -e "$STATE"/mute ]; then
      #unmute
      VOL="$(cat "$STATE"/mute 2>/dev/null)"
      cmd rm -f "$STATE"/mute
      cmd "$AUMIX" -v"${VOL:-90}"
    else
      #mute (and remember current volume level)
      VOL="$($AUMIX -q | grep ^vol | awk ' { print $3; }')"
      cmd echo "${VOL:-90}" >"$STATE"/mute
      cmd "$AUMIX" -v0
    fi 
  ;;
  fn-f4)
    if [ ! -e "$STATE"/level_pcm ]; then
      #select PCM as currently being adjusted
      cmd rm -f "$STATE"/level_*
      cmd touch "$STATE"/level_pcm
    else
      #deselect PCM as currently being adjusted (default is MASTER volume)
      cmd rm -f "$STATE"/level_*
    fi
  ;;
  fn-f5)
    #select brightness as currently being adjusted
    cmd rm -f "$STATE"/level_*
    cmd touch "$STATE"/level_brightness
  ;;
  fn-1)
    if [ -e "$STATE"/level_pcm ]; then
      #adjust voulme (PCM) -10
      cmd "$AUMIX" -w-10
    else
      if [ -e "$STATE"/level_brightness ]; then
        #adjust brightness -32
	cmd "$SPICCTRL" -B >/dev/null  #hack: sometimes first call returns wrong value
        VALUE="$(($("$SPICCTRL" -B) - 32))"
        [ $VALUE -lt 0 ] && VALUE=0
        cmd "$SPICCTRL" -b $VALUE
      else
        #adjust voulme (MASTER) -10
        cmd "$AUMIX" -v-10
      fi
    fi
 ;;
 fn-2)
    if [ -e "$STATE"/level_pcm ]; then
      #adjust voulme (PCM) +10
      cmd "$AUMIX" -w+10
    else
      if [ -e "$STATE"/level_brightness ]; then
        #adjust brightness +32
	cmd "$SPICCTRL" -B >/dev/null  #hack: sometimes first call returns wrong value
        VALUE="$(($("$SPICCTRL" -B) + 32))"
        [ $VALUE -gt 255 ] && VALUE=255
        cmd "$SPICCTRL" -b $VALUE
      else
        #adjust voulme (MASTER) +10
        cmd rm -f "$STATE"/mute
        cmd "$AUMIX" -v+10
      fi
    fi
  ;;
  p-p1)
    #DISPLAY=:0.0 xclock  -geometry +100+100 -digital
  ;;

  fn-f12)
    ## see http://swsusp.sourceforge.net/
    #cmd hibernate
    ;;

  #add any other definitions here
  #see available key names in strings.c file (not all may be available on your laptop)
  
  *) 
    #log key events without any action 
    $LOG && echo "no action on key: $KEY"
  ;; 
esac
  
