/*
 *  sonykeyd.c - sony special key daemon
 *               version 0.02
 *
 *  Copyright (C) 2002 Jan Slupski (jslupski@email.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* 
ChangeLog:
0.02
Thu Dec 30 15:52:15 CET 2004
  - fix for possible 'for bomb' - thanks to Nicolas Noble
  - added some comments
0.01
  - initial version
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>

#include <linux/sonypi.h>

#define DEFAULT_COMMAND "/usr/local/sbin/sonykey.sh"

extern const char *event_names[];
int get_event_id(int event);
int run(const char*command,const char *arg);

int as_daemon(void){
int nullfd;

	switch(fork()) {
		case -1:
			fprintf(stderr, "sonykeyd: fork: %s\n", strerror(errno));
			return -1;
		case 0:
			/* child */
			break;
		default:
			/* parent */
			exit(EXIT_SUCCESS);
	}
  setsid();
  umask(0);

  nullfd = open("/dev/null", O_RDONLY, 0640);
  if (nullfd < 0) {
    fprintf(stderr, "sonykeyd: can't open %s: %s\n", "/dev/null", strerror(errno));
    return -1;
  }
  if (dup2(nullfd, STDIN_FILENO) != STDIN_FILENO) {
    fprintf(stderr, "sonykeyd: dup2: %s\n", strerror(errno));
    return -1;
  }

	chdir("/");
  return 0;
}


int main(int argc, char *argv[]) {
	int fd;
	fd_set rfds;
	int retval;
	unsigned char event;
	char *command;

  as_daemon();

	if(argc>1)
		command=argv[1];
	else
		command=DEFAULT_COMMAND;
		

	if ( (fd = open("/dev/sonypi", O_RDONLY)) == -1) {
		fprintf(stderr, "Failed to open /dev/sonypi: %s\n", 
			strerror(errno));
		return -1;
	}

	//loop waiting for events on sonypi
	while(1){
		FD_ZERO(&rfds);
		FD_SET(fd, &rfds);

		//wait for any input
		retval = select(fd + 1, &rfds, NULL, NULL, NULL);

		//error
		if (retval == -1) {
			fprintf(stderr, "select failed: %s\n", strerror(errno));
			return -1;
		}

		if (FD_ISSET(fd, &rfds)) {
			//read the event 
			if (read(fd, &event, sizeof(event)) != sizeof(event)) {
				fprintf(stderr, "read failed: %s\n", strerror(errno));
				return -1;
			}
		}
		//execute script with the event as an argument
		run(command,event_names[get_event_id(event)]);
	}

	close(fd);
	return 0;
}


int run(const char*command,const char *arg){
	int pid;
	int status;
	pid=fork();
	if(pid==0){
		//execute command in separate process
		execl(command,command,arg,NULL);
		exit(1); 
	}
  waitpid(pid,&status,0);
	return 0;
}
