#include <linux/sonypi.h>
const char *event_names[]={
	"unknown",
	"jd-down",
	"jd-up",
	"jd-down-P",
	"jd-up-P",
	"jd-P",
	"jd-R",
	"cp-P",
	"cp-R",
	"cp-partP",
	"cp-partR",
	"fn-esc",
	"fn-f1",
	"fn-f2",
	"fn-f3",
	"fn-f4",
	"fn-f5",
	"fn-f6",
	"fn-f7",
	"fn-f8",
	"fn-f9",
	"fn-f10",
	"fn-f11",
	"fn-f12",
	"fn-1",
	"fn-2",
	"fn-d",
	"fn-e",
	"fn-f",
	"fn-s",
	"fn-b",
	"p-bt",
	"p-p1",
	"p-p2",
	"p-p3",
	"max"
};

int get_event_id(int event){
	switch(event){
		case SONYPI_EVENT_JOGDIAL_DOWN:              return 1;
		case SONYPI_EVENT_JOGDIAL_UP:                return 2;
		case SONYPI_EVENT_JOGDIAL_DOWN_PRESSED:      return 3;
		case SONYPI_EVENT_JOGDIAL_UP_PRESSED:        return 4;
		case SONYPI_EVENT_JOGDIAL_PRESSED:           return 5;
		case SONYPI_EVENT_JOGDIAL_RELEASED:          return 6;
		case SONYPI_EVENT_CAPTURE_PRESSED:           return 7;
		case SONYPI_EVENT_CAPTURE_RELEASED:          return 8;
		case SONYPI_EVENT_CAPTURE_PARTIALPRESSED:    return 9;
		case SONYPI_EVENT_CAPTURE_PARTIALRELEASED:   return 10;
		case SONYPI_EVENT_FNKEY_ESC:                 return 11;
		case SONYPI_EVENT_FNKEY_F1:                  return 12;
		case SONYPI_EVENT_FNKEY_F2:                  return 13;
		case SONYPI_EVENT_FNKEY_F3:                  return 14;
		case SONYPI_EVENT_FNKEY_F4:                  return 15;
		case SONYPI_EVENT_FNKEY_F5:                  return 16;
		case SONYPI_EVENT_FNKEY_F6:                  return 17;
		case SONYPI_EVENT_FNKEY_F7:                  return 18;
		case SONYPI_EVENT_FNKEY_F8:                  return 19;
		case SONYPI_EVENT_FNKEY_F9:                  return 20;
		case SONYPI_EVENT_FNKEY_F10:                 return 21;
		case SONYPI_EVENT_FNKEY_F11:                 return 22;
		case SONYPI_EVENT_FNKEY_F12:                 return 23;
		case SONYPI_EVENT_FNKEY_1:                   return 24;
		case SONYPI_EVENT_FNKEY_2:                   return 25;
		case SONYPI_EVENT_FNKEY_D:                   return 26;
		case SONYPI_EVENT_FNKEY_E:                   return 27;
		case SONYPI_EVENT_FNKEY_F:                   return 28;
		case SONYPI_EVENT_FNKEY_S:                   return 29;
		case SONYPI_EVENT_FNKEY_B:                   return 30;
		case SONYPI_EVENT_BLUETOOTH_PRESSED:         return 31;
		case SONYPI_EVENT_PKEY_P1:                   return 32;
		case SONYPI_EVENT_PKEY_P2:                   return 33;
		case SONYPI_EVENT_PKEY_P3:                   return 34;
		default:                                     return 0;
	}
	return 0;
}

